
import java.awt.*;
import java.awt.image.*;
import java.util.*;
import java.io.*;
import java.net.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;

/** An instance of this class is an image and a thumbnail of it. The
    instance is a window, since it extends JFrame, The window contains
    only the image itself and a title.<br><br>
 
    Methods exist for displaying the image in a frame and manipulating
    the image. All your changes will be made in this class --you'll
    change methods hreflect, vreflect, and transpose.<br><br>

    Every method that changes the image calls method refreshImage at the
    end, to make sure that the changes are reflected both in this window
    and in the main GUI-window for the program, which contains all
    the thumbnail pictures. Method refreshImage calls method formImage
    with the right image as its argument. */


public class ImageBox extends JFrame {
  
	ImageHandler handler; // the image handler for this

	int imagenum;         // number of the image in the handler
	String filename;      // the file name of the image
	
	Image image;          // the image
    Thumbnail thumbnail;  // the thumbnail
	MediaTracker tracker; // the media tracker for the image

	ImageMap imageMap;    // the array representation of the image
	ImageMap oldImageMap; // Original map (for restoring)

	int rows;             // the number of rows of the image
    int cols;             // the number of columns of the image

	ImageCanvas imageCanvas; // the canvas to display the image

	String title;         // the window title
	  
	// = the thumbnail of the image
	public Thumbnail getThumbnail() {
		return thumbnail;
	}

	/** Constructor: An image for m whose file name is f. A thumbnail of the
	   image is also created and stored. n is the index of the 
	   image in the array of the handler.<br>
	   If map is null, then the image comes from file f;
	       otherwise, the image that is in map is used.<br>
	   if oldmap is null, the image from file f is saved and used when the restore
	       menu button is clicked; otherwise, oldmap is used. */
	public ImageBox(String f, ImageMap map, ImageMap oldmap, ImageHandler m, int n) {
	      handler= m;       // store the handler
          imagenum= n;      // store the image number
		  filename= f;      // store the file name
		  // create and store the image
			  try {
				  image= getToolkit().getImage(new URL("file:" + filename));
			  } 
			  catch (MalformedURLException e) {
				System.err.println("Bad URL!");
			  }
		  // set media tracker to wait for image to load
			  tracker= new MediaTracker(this);
			  tracker.addImage(image,0);    
          // wait for image to load
			  try { tracker.waitForID(0); 
				  }
	          catch (InterruptedException e) {
				     handler.flashMessage(ImageHandler.LOAD_INTERRUPTED);
				     return;
				  }		  
		  
		  thumbnail= new Thumbnail(this);      // create and store thumbnail
		  imageCanvas= new ImageCanvas(this);  // create the image canvas
		  // store the dimensions of the image map
			  rows= image.getHeight(imageCanvas);
			  cols= image.getWidth(imageCanvas);
		  // if map is null, store the new image in imageMap; otherwise store map
		  //  in imageMap
			  if (map == null) 
			     imageMap= new ImageMap(image,rows,cols);
			  else {
				  imageMap= map;
				  refreshImage();
			  }
		  // if oldmap is null, store the new image in oldImageMap; otherwise store
		  // oldmap there. oldImageMap is used when the restore menu item is used.
			  if (oldmap == null)
				    oldImageMap= imageMap.copy();
			  else  oldImageMap= oldmap.copy();
		  // set window title
			     String imageType;			  
			     if (filename.charAt(filename.length()-1) == 'g')
				       imageType= "JPEG";
			     else imageType= "GIF";
			     title= imageType + " Image" + " - " + filename;
			     setTitle(title);
		  // add image to JFrame
	        getContentPane().add(BorderLayout.CENTER,imageCanvas);
		  // add window closing event handler
	        addWindowListener(new WindowAdapter() {
              public void windowClosing(WindowEvent e) {
					 handler.closeWindow();
			  }});
		  // finalize Frame
			  setLocation(300,300);
			  pack();
			  setVisible(true);
	  }

	/** = a copy of the image */
	public ImageBox copy() {
		return new ImageBox(filename,imageMap,oldImageMap,handler,imagenum);
	}

	/** methods used by system to size canvas */
	public Dimension getPreferredSize() {
		return new Dimension(cols,rows+27);
	}
	  
	public Dimension getMinimumSize() {
	   return new Dimension(cols,rows+27);
	}

	/** Create an image from image map */
	public void formImage(ImageMap map) {
		rows= map.getRows();
		cols= map.getCols();
		image= imageCanvas.createImage(
		       new MemoryImageSource(cols,rows,map.getMap(),0,cols));
		thumbnail= new Thumbnail(this);
		imageCanvas= new ImageCanvas(this);
		handler.displayThumbnails();
		pack();
		setVisible(false);
		setVisible(true);
	}  

	/** Refresh the image */
	public void refreshImage() {
	   formImage(imageMap);
	}

	/** Restore the original image */
	public void restoreImage() {
      imageMap= oldImageMap;
      refreshImage();
	}

	/** Invert the image, replacing each element with its color complement
	    When done, call refreshImage. */
	public void invert() {
      DirectColorModel dm = (DirectColorModel)
	   ColorModel.getRGBdefault();
	   // invert all pixels (leave alpha/transparency value alone)
		   for (int i=0; i<rows; i++)
				for (int j=0; j<cols; j++) {
				   int rgb= imageMap.getPixel(i,j);
				   int red= 255 - dm.getRed(rgb);
				   int blue= 255 - dm.getBlue(rgb);
				   int green= 255 - dm.getGreen(rgb);
				   int alpha= dm.getAlpha(rgb);
				   imageMap.setPixel(i,j,
				       (alpha << 24) | (red << 16) | (green << 8) | blue);
			} 
		refreshImage();
	}

	// = the file name of an image loaded by the user
	public static String loadImage() {
		FileDialog fd = new FileDialog(new Frame(), "Open File", FileDialog.LOAD);
	    fd.setVisible(true);
		if (fd.getFile() == null) 
			return null;
		return fd.getDirectory() + fd.getFile();
	}
	
	/** Transpose this image --which is in variable imageMap
	    This will require constructing a new array b (say) of class imageMap,
	    storing the transpose of imageMap in b, and then assigning b to imageMap
        When done, call method refreshImage. */
	public void transpose() {
	    // You fill in code here
		refreshImage();
	}
	
	/** Reflect this image (in variable imageMap) around the horizontal middle
	    When done, call method refreshImage. */
	public void hreflect() {
	    // You fill in code here
		refreshImage();
	}
	
    /** Reflect this image (in variable imageMap) around the vertical middle
	    When done, call method refreshImage. */
	public void vreflect() {
	    // You fill in code here
		refreshImage();
	}
}
		  

		  

	

